/*
 * Decompiled with CFR 0.152.
 */
package dttraverse.worldgen;

import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.worldgen.BiomePropertySelectors;
import com.ferreusveritas.dynamictrees.api.worldgen.IBiomeDataBasePopulator;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.worldgen.BiomeDataBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import prospector.traverse.world.TraverseWorld;

public final class BiomeDataBasePopulator
implements IBiomeDataBasePopulator {
    public void populate(BiomeDataBase biomeDataBase) {
        Species fir = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dttraverse", "fir"));
        Species autumnBrown = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dttraverse", "autumn_brown"));
        Species autumnOrange = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dttraverse", "autumn_orange"));
        Species autumnRed = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dttraverse", "autumn_red"));
        Species autumnYellow = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dttraverse", "autumn_yellow"));
        Species miniJungle = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dttraverse", "mini_jungle"));
        Species oakShrub = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dttraverse", "oak_shrub"));
        Species birch = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictrees", "birch"));
        Species oak = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictrees", "oak"));
        Species spruce = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictrees", "spruce"));
        Species acacia = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictrees", "acacia"));
        Species swamp = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictrees", "oakswamp"));
        Species darkOak = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictrees", "darkoak"));
        Species cactus = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictrees", "cactus"));
        this.addSpeciesSelector(biomeDataBase, TraverseWorld.autumnalWoodsBiome, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(autumnYellow, 4).add(autumnOrange, 5).add(oak, 1).add(autumnBrown, 2).add(autumnRed, 4));
        this.addDensitySelector(biomeDataBase, TraverseWorld.autumnalWoodsBiome, this.scale(0.9));
        this.addChanceSelector(biomeDataBase, TraverseWorld.autumnalWoodsBiome, this.chance(1.0f));
        this.addSpeciesSelector(biomeDataBase, TraverseWorld.autumnalWoodedHillsBiome, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(autumnYellow, 4).add(autumnOrange, 5).add(oak, 1).add(autumnBrown, 2).add(autumnRed, 4));
        this.addDensitySelector(biomeDataBase, TraverseWorld.autumnalWoodedHillsBiome, this.scale(0.9));
        this.addChanceSelector(biomeDataBase, TraverseWorld.autumnalWoodedHillsBiome, this.chance(1.0f));
        this.addSpeciesSelector(biomeDataBase, TraverseWorld.temperateRainforestBiome, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.StaticSpeciesSelector(fir));
        this.addChanceSelector(biomeDataBase, TraverseWorld.temperateRainforestBiome, this.chance(1.0f));
        this.addSpeciesSelector(biomeDataBase, TraverseWorld.snowyConiferousForestBiome, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.StaticSpeciesSelector(fir));
        this.addChanceSelector(biomeDataBase, TraverseWorld.snowyConiferousForestBiome, this.chance(1.0f));
        this.addSpeciesSelector(biomeDataBase, TraverseWorld.aridHighlandBiome, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(acacia, 4).add(oak, 1).add(cactus, 1));
        this.addDensitySelector(biomeDataBase, TraverseWorld.aridHighlandBiome, this.scale(0.1));
        this.addChanceSelector(biomeDataBase, TraverseWorld.aridHighlandBiome, this.chance(0.2f));
        this.addSpeciesSelector(biomeDataBase, TraverseWorld.badlandsBiome, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(autumnBrown, 1).add(oak, 1));
        this.addDensitySelector(biomeDataBase, TraverseWorld.badlandsBiome, this.scale(0.03));
        this.addChanceSelector(biomeDataBase, TraverseWorld.badlandsBiome, this.chance(0.0625f));
        this.addSpeciesSelector(biomeDataBase, TraverseWorld.birchForestedHillsBiome, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.StaticSpeciesSelector(birch));
        this.addChanceSelector(biomeDataBase, TraverseWorld.birchForestedHillsBiome, this.chance(1.25f));
        this.addSpeciesSelector(biomeDataBase, TraverseWorld.forestedHillsBiome, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(oak, 4).add(birch, 2));
        this.addDensitySelector(biomeDataBase, TraverseWorld.forestedHillsBiome, this.scale(0.9));
        this.addChanceSelector(biomeDataBase, TraverseWorld.forestedHillsBiome, this.chance(1.0f));
        this.addSpeciesSelector(biomeDataBase, TraverseWorld.lushHillsBiome, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(oak, 4).add(swamp, 1));
        this.addDensitySelector(biomeDataBase, TraverseWorld.lushHillsBiome, this.scale(0.4));
        this.addChanceSelector(biomeDataBase, TraverseWorld.lushHillsBiome, this.chance(1.0f));
        this.addSpeciesSelector(biomeDataBase, TraverseWorld.lushSwampBiome, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(swamp, 4).add(oak, 1));
        this.addDensitySelector(biomeDataBase, TraverseWorld.lushSwampBiome, this.scale(0.6));
        this.addChanceSelector(biomeDataBase, TraverseWorld.lushSwampBiome, this.chance(1.0f));
        this.addSpeciesSelector(biomeDataBase, TraverseWorld.meadowBiome, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(oak, 2).add(birch, 1));
        this.addDensitySelector(biomeDataBase, TraverseWorld.meadowBiome, this.scale(0.01));
        this.addChanceSelector(biomeDataBase, TraverseWorld.meadowBiome, this.chance(0.5f));
        this.addSpeciesSelector(biomeDataBase, TraverseWorld.rockyPlainsBiome, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(oak, 2));
        this.addDensitySelector(biomeDataBase, TraverseWorld.rockyPlainsBiome, this.scale(0.01));
        this.addChanceSelector(biomeDataBase, TraverseWorld.rockyPlainsBiome, this.chance(0.05f));
        this.addSpeciesSelector(biomeDataBase, TraverseWorld.rockyPlateauBiome, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(oak, 2));
        this.addDensitySelector(biomeDataBase, TraverseWorld.rockyPlateauBiome, this.scale(0.01));
        this.addChanceSelector(biomeDataBase, TraverseWorld.rockyPlateauBiome, this.chance(0.5f));
        this.addSpeciesSelector(biomeDataBase, TraverseWorld.thicketBiome, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(oak, 4).add(darkOak, 2));
        this.addDensitySelector(biomeDataBase, TraverseWorld.thicketBiome, this.scale(1.5));
        this.addChanceSelector(biomeDataBase, TraverseWorld.thicketBiome, this.chance(1.0f));
        this.addSpeciesSelector(biomeDataBase, TraverseWorld.woodlandsBiome, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.StaticSpeciesSelector(oak));
        this.addDensitySelector(biomeDataBase, TraverseWorld.woodlandsBiome, this.scale(0.6));
        this.addChanceSelector(biomeDataBase, TraverseWorld.woodlandsBiome, this.chance(0.75f));
        this.addSpeciesSelector(biomeDataBase, TraverseWorld.redDesertBiome, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.StaticSpeciesSelector(cactus));
        this.addDensitySelector(biomeDataBase, TraverseWorld.redDesertBiome, this.scale(2.0));
        this.addChanceSelector(biomeDataBase, TraverseWorld.redDesertBiome, this.chance(0.05f));
        this.addSpeciesSelector(biomeDataBase, TraverseWorld.mountainousDesertBiome, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.StaticSpeciesSelector(cactus));
        this.addDensitySelector(biomeDataBase, TraverseWorld.mountainousDesertBiome, this.scale(2.0));
        this.addChanceSelector(biomeDataBase, TraverseWorld.mountainousDesertBiome, this.chance(0.05f));
        this.addSpeciesSelector(biomeDataBase, TraverseWorld.miniJungleBiome, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(oak, 1).add(miniJungle, 4));
        this.addDensitySelector(biomeDataBase, TraverseWorld.miniJungleBiome, this.scale(2.0));
        this.addChanceSelector(biomeDataBase, TraverseWorld.miniJungleBiome, this.chance(0.85f));
        this.addSpeciesSelector(biomeDataBase, TraverseWorld.cliffsBiome, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(oak, 2).add(4));
        this.addDensitySelector(biomeDataBase, TraverseWorld.cliffsBiome, this.scale(2.0));
        this.addChanceSelector(biomeDataBase, TraverseWorld.cliffsBiome, this.chance(0.5f));
        this.addSpeciesSelector(biomeDataBase, TraverseWorld.glacierBiome, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(spruce, 2).add(8));
        this.addDensitySelector(biomeDataBase, TraverseWorld.glacierBiome, this.scale(2.0));
        this.addChanceSelector(biomeDataBase, TraverseWorld.glacierBiome, this.chance(0.5f));
        this.addSpeciesSelector(biomeDataBase, TraverseWorld.glacierSpikesBiome, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(spruce, 2).add(8));
        this.addDensitySelector(biomeDataBase, TraverseWorld.glacierSpikesBiome, this.scale(2.0));
        this.addChanceSelector(biomeDataBase, TraverseWorld.glacierSpikesBiome, this.chance(0.5f));
        this.addSpeciesSelector(biomeDataBase, TraverseWorld.desertShrublandBiome, (BiomePropertySelectors.ISpeciesSelector)new BiomePropertySelectors.RandomSpeciesSelector().add(oakShrub, 3).add(8));
        this.addDensitySelector(biomeDataBase, TraverseWorld.desertShrublandBiome, this.scale(0.8f));
        this.addChanceSelector(biomeDataBase, TraverseWorld.desertShrublandBiome, this.chance(0.6f));
        Biome.field_185377_q.forEach(biome -> {
            if (biome.getRegistryName().func_110624_b().equals("traverse")) {
                biomeDataBase.setCancelVanillaTreeGen(biome, true);
            }
        });
    }

    private void addSpeciesSelector(BiomeDataBase dbase, Biome biome, BiomePropertySelectors.ISpeciesSelector selector) {
        dbase.setSpeciesSelector(biome, selector, BiomeDataBase.Operation.REPLACE);
    }

    private void addDensitySelector(BiomeDataBase dbase, Biome biome, BiomePropertySelectors.IDensitySelector selector) {
        dbase.setDensitySelector(biome, selector, BiomeDataBase.Operation.REPLACE);
    }

    private void addChanceSelector(BiomeDataBase dbase, Biome biome, BiomePropertySelectors.IChanceSelector selector) {
        dbase.setChanceSelector(biome, selector, BiomeDataBase.Operation.REPLACE);
    }

    private BiomePropertySelectors.IDensitySelector scale(double factor) {
        return (rand, noiseDensity) -> noiseDensity * factor;
    }

    private BiomePropertySelectors.IChanceSelector chance(float value) {
        if (value <= 0.0f) {
            return (rnd, spc, rad) -> BiomePropertySelectors.EnumChance.CANCEL;
        }
        if (value >= 1.0f) {
            return (rnd, spc, rad) -> BiomePropertySelectors.EnumChance.OK;
        }
        return (rnd, spc, rad) -> rnd.nextFloat() < value ? BiomePropertySelectors.EnumChance.OK : BiomePropertySelectors.EnumChance.CANCEL;
    }
}

